(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     95842,       1893]
NotebookOptionsPosition[     93049,       1841]
NotebookOutlinePosition[     93387,       1856]
CellTagsIndexPosition[     93344,       1853]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
This Notebook contains the proofs of all the results in the paper
\"The Shape of Central Quadrilaterals\" by Stanley Rabinowitz and Ercole Suppa,
submitted to the International Journal of Computer Discovered Mathematics 
(http : // www.journal - 1. eu/) in January 2022.
 
This Notebook is Copyright \[Copyright] January 2022 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and is published with open access. This \
Notebook is distributed under the terms of the Creative Commons Attribution \
License which permits any use, distribution, and reproduction in any medium, \
provided the original author and the source are credited.\
\>", "Text",
 Evaluatable->False,
 CellChangeTimes->{{3.823362867312365*^9, 3.823362892123764*^9}, {
  3.823362940554699*^9, 3.823363012293025*^9}, {3.823423241988761*^9, 
  3.8234232521964083`*^9}, {3.848655919648938*^9, 3.8486559295098267`*^9}, {
  3.850294942155574*^9, 
  3.8502949868845367`*^9}},ExpressionUUID->"a16683d9-b289-4d5a-a025-\
a9196fb82139"],

Cell[CellGroupData[{

Cell["Theorem 5.1", "Section",
 CellChangeTimes->{{3.851255065653489*^9, 
  3.851255077810506*^9}},ExpressionUUID->"d4a13e5d-e35b-494d-bc2c-\
5a27372e6028"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsnQW0HTX3t4u7u7e4OxR39xZ3LV6kFHcr7u7u7k5xKO5WtBR3d+Z7n/zX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    "], {{0, 188}, {1046, 0}}, {0, 
    255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{1046, 188},
  PlotRange->{{0, 1046}, {0, 188}}]], "Input",
 Evaluatable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"14a64d69-00fa-49c0-953b-2ad7bbe78ef4"],

Cell["\<\
Without loss of generality, we can place B at the origin and C at (1,0).
Let the Cartesian coordinates for A be (ax,ay) and let the coordinates for D \
be (dx,dy).
The intersection of the diagonals will be called E and has coordinates \
(ex,ey).\
\>", "Text",
 CellChangeTimes->{{3.815654632263982*^9, 
  3.815654724079246*^9}},ExpressionUUID->"6c77ebfc-22f8-4071-8dd1-\
2f722f3c0b60"],

Cell[GraphicsData["PDF", "\<\
9E14ARda;S<:9LCUl^G[Yo>Pd<C62S@P<21_HVX:?3`P;daUKVMdJ20e830PDR0_
AVU/M6Eb82m6K65dIDAUHfmTIB0n?PYcM79UHFd:N065EDe_fc0<_N]Gl9P0Rb]:
UVDOUjbGgX[h]^h`^1^6HSd4?Fckmb<YDEJRY4D0Aj;hnOQ4WN0AC^3Q3b0lP8<G
^3^l8Ab>H>Eg?=0abW;7O`hS;:l@GALPS?Ai1LMo><@^V=m`57n]`J[45Rj82Gn_
VaR:DF_AcU80L===4dj[DZYbc6TQ5GV]U_?D?P[3VIeEgm@R02i_6L2gY@A=n76N
naV`5`Gj`h0`SFInQK]iAP9koPUOHO>dnK65WNdLK?infX8/R^COdgH;gf1nP?^i
@Y`SH?BLheT8ibJ24mX@cdf88TTQc8d@CAD^GXo`_HYPY8PRNJN87LJY3H4>L1Ze
3;<RQAY4PK8Z^8gC3TNQlQU@B1BckTX_R/<?8W3o4:ZVjjgQWR1cIO0NY[icJ2Nn
?J//M1i3X19Mg`d3eCl=F@^McgIIHQKBLUdOa[7F`ZbeNU:9aV<kUOT>kN17/gYb
CCbE/9eVYK8elmGCIGd;o88m4C@=T`XFHF[KH_Ad5bKZ/:6k@53`GMSLKf5nBDC7
cPFIECM@I/k4PFI4WTfl=X?]XYgXY/Dn;`HNGg:;IKE096I>MQa0mP=?]68U>o6g
V;BV;XQb/@ZmnY<EnM=8jD@b:UJJ7gGa?GA/2dn84?[<OdGW<j=SI0cL91o3h[UV
6M?4^[bI10o`2Q168XM90i6G/83C]>D<R0G/9A_V7DmVdTa7PL6QLI?]30i4GWdT
N;UDlN@/9i<=Zc`_lC4WHPACRKlkk;4I4LScSoW3/e@AfUOl8E>nW/FCGTofA5=B
R^=WJMg5Q95cNL75Dceik=>Jf^SXPT[EN/SH<MK<>cY=FoK;^VVG;BYCTQ_ebcZ/
Fh:b@1</YV^nUe31RLKS2YE_^N@lHjGCE;4j]5PEEfMHXBC42A1D/_6HKiNcbR_Y
_;bX?WGNfMAU8g]WFE[IRCkkY=;US>Y?Edd=@G3?kk`0JTZhM9@B:gI[WRe45I^X
LD@1LoHHT6<Rm@FI_Z`0?Oh7_ngH?0YUKVAcM79UHFd:IFiTKf9Z2SDP<21_HVX:
=cH`2VE^I6mRJPXb830PKf9Z2S`l82mDNG1U82m@HFMU82m@HG9UKW@P<b0`858P
;e9ULfmeLV=ULb0f830PDR0_@fm^M6E^M7<P=20`858P;deUI6UQ@Vmh85/`830P
<SPe838a=ed:?Sh:IFiTKf9Z2SHP<21_HVX:?3`P;e1bKf=CIG@PFb0_D4A682mD
IGQd85dP;d=_K6mbDg1QHfDP?3`P;d=c<B0g830PDR0n?R0_AVm^M20l?20_E5@b
83TP<21B2RmDE34P>20`858P?ShP?Sh:IFiTKf9Z2S4`830PKf9Z2S`l82m<IFiW
M6PP<C4P<21B82m>83<P;d5/M6EbKV5dIB0_A6EfJF=UDTM282m6JFadIG8P;dI/
HGAUA6ESKfAU83hn2W=dLVEQK@Yh0IfFMeACfAJ7ckdg_M0B8R0Um1Yj2B3B>dPE
1569BH1@0XJ49WI41DHD4BUFI5C00DN78V=550^3PV;G2O8@D<K1DDA5iMf<J`W_
[CGcgY[maeWOfNNgemUWkggG^P1@o884`WAH0H0dXEPDk^_1G18CblCg0QP@0@iH
0L3QIVH4AoQ40]Cl_CfIVJQ8a[?fkRj0I;_K;;m@9W?FognA8SM390H02TGE=San
9QOU0YAC/lDI<_l4b_BE:C:6<C8FX@VR[2;Sa:m/mZOV:k_9V9LVi:4JFLhI_3BN
S;]@gYXUhJ><1:5LV2GPIj=l1fFmE4VJ0>Gg:=?Cn9a<030DVEo<ibJQK8TbAA@I
kXWb0P08U<@i_78>RoTiJ9h0N:IWi8X4RDURYQ7GV6WUj<QVn_6cDoUR<B^D`dgQ
R7Q<coBd38h`5h2_KiI50BEIKIUXTNf]7>g]FMKVJ?VofMlNOU?m?LQjneGa9^c?
WT6<WUWOK>b/;kdF0?HTFY/M/kjEE@2dK@I0iN6/CnlP0?850;CNW?<NQVaNT/CR
32L;Rnc/K7<1Wf/^:nPgnin2KlZoQSWgVL_^neHkYQLoPB=95C=UANFVYjI;A<c<
30jGcfCmma3ohl0iJLg9`bbLWl0GlHGXEE7XU0V4RFRkQCb1F90^I0Z4OmGQOaPf
9`LIOYe[56QeG`1mQCU@^4T7b6lm04<S0bA^?gX2ON]K434:b;jlJ:fA[g>?<W[n
ioXO2eb:K^5<@B9Ci_H<SfAb9J8/6J?OQ6c10Q:@1gBP2SB1;S02;60=780cL0?N
8024P4P@0iH3;TP2JD04/T4nf00:@C7H0GJ3JW00e85jd0A>PSI`1U`4El0=L0/<
P4M02XK1Bc01gX5Y28;`41FR@JZ@5Z@?VD;F41]J27U3@E0h50?5@hV@4990nM0V
Z1PZPjZQ@e0mm2=d6[X8GH?jX0O@83@6o@5mQ16H0]=Q3MP0]X3I/3/L24O2bn14
N1FL1aO0fn5:^1Hn3[O25n4Kl00/QEo2T`Q0b0P3dDIH21_aA4:@F2@14B5[TB:T
0ZU5VY0>Y1^iSDRALN@31XNQHIPH5/HIhhMIS>5REV7FHTX`eIQSV5I<5nHfIQ0c
POV2YF;E/JIH9j`oMPTf4I^=;LAFH8mPFk2G/@?HHN`k70k7`1WR771n^1QL<Vhe
[PBg3mN<^h3[``gQ9_5h_2[N5>n23l5cl69l8Kh:Oaao7]n?7lJo9i09FPA[PPlQ
UR0TK2AD41X8i`SmQ172=561Z4md8XH@NLALHRVaS]Q1_4TL9TjC54V691MB92VI
]85DBFXRGBHm9[dQTlTjI4Mb65U0GTn^99lPGbD?TSm@U2PV54m:74E2fDhiB[U0
ND1i@jEB3JQ^e5RZV;ZMFTnmA7e:OBm7Tc>GliOSbJfCZi5[UN^GNbE?U=NGMiMO
;YlWGb5oB_jVo;P2DL50`E>1Xk1FXDKQ]<8mQDU5VZ:EHXQRVV:9HX?R=LEA9KbB
PI:g4TnY@>V`dRFU8AY2djEid[RdCK@jfVGJ<1e7=jCkdi?YaO@Oj;gd2FDUIE_U
:>DLiA[U/lYB1/8`H?PcDQVUS9><^hb?lcCV^LoScm/f[fUNok`YUOTZKRYlUB:E
IYD1UHnZC5E_eACEWJY]ZToD<6XVJV5ZfF[keBj[SLnWcgNNcieO=?oTo8OZ/;Z9
N[SjJ_G3jSgZTaZJ6[hJ6AYE6YLdaSDIVVjJbI[UV^LdakAXFP^e15[UF^NeGS2E
VNk<E6HU/h/iXJf^kJL]dCjTgJ/m[F>X/eQWXdjccQ=MTRiK=d6gG;MCMd9?BbmH
;en_DNnQ?U6O[InT_dNoFgo:`=0PfV2;@I_1Z:6:XKmQWV6ShF<SZY6[dBZSFZ<k
aSQS]W6:lCkSFbJ`RIe9TTV=bDeCf=CNE62jckC?36_VJ2HdZcFkaj:`g5UI[4KF
X3W3?<QlXgVKnB/;?H]HRidFgAIO;>d/Dbg[;1mI:ET5F6fdj[3j`m[4VV]MHgg7
QV[SHk?>Y]gV]JfY;Mmf_nem>iYM/=dF^djkcoH>mR;k9_/a1cf7N8Nm3_OHM7HX
^hAmeA7[j>6hc_6<h`LWNbNaddVWgieIcRW>3LjS2``Gl1OD;AQbdG7Q^1abTBiT
;XaON72Qe5GKUN=Jjo[<CMN=igK4KLCMf3gIoKSk:`m;3i57RlNDYi?W6/l;GXRG
[eNAEjngT_MRkf[_Ychj?XTnSChC_WJnZgd_n67m0_efn]gceo3Wn]OkC`@h1:`9
j0ZT14H4EPLn2c894PEe1<?10L6kPQl_dUlTG=@F0T;l@gJ5?0Te35dEnW<H;R`d
[2K/NKQEN7ihM`@]HTE4@lBkB8o8d/Q7RhdFBaIgA/U7aDGEAde5NdFGAD^GF2aI
/nA6S5Z<8:Hm5QlK5G/TMW:Ymm;MBhOSk>8:hnh^<ebF/ncJL[GUZL_?[Y1O`EUa
:QhK7agO4?n94l:YiDb^m5niMnD4ei>kQo^BilH[ihgaGOQUo944UhBbQ=54UlAM
RF=9[TTEBN<2Cd6eh7FbGo:1i:VDT9BS:C>YdJW=JHBdn;CC@REQR[0[GC<m9kd_
`cBS<4>jbVWEkUDCXT3ATD`XLeUV^iR>oTceB8`TVbF3F@^cJ[;NIdMUWlYAc17V
m>BJi6k;7LWcbO]n=FHeMgEW_WKnQ_c1=Ni[3Zf5eZiLfkU>Meg1^^7e_^^?KB1]
B=W`bdK;SFDKgfj:g]AAX56`_V1X/noVaT:i@U7Q_Bg>F`i/aF`EK>gMI[>]J]^G
8UkAmF;;hX[RCbGLT^_OFGeGnMg<mXC]_JGfYO]gh7H8MmcMjK[cF9URFEkId:kP
GJgUc?:Rl[NkEnbnEV5KLF0?JHmTSk@bZ;:mBZmZAmFWjZCZPAZ?V^JmjW^gkIgJ
am_G_mm]Om<1S@?51chN51blOlSgD6^]@Fg5HMcQ[<??jj;Z^[mWOemoA>e8lI7?
AhE7YLO2SgGE>mCG=jPgU3K2SI;6/N=aafomh?E3Na>[jE0cXkWh13PQ>O7RaoPO
kih<?=UiRWfZjBOmWoJfd5Z:FZ7Fg=J9]Z@fJG]<NmoYP=>M7LhM;CnKogcdS?JI
V[?:Id_?TLhEW9/iWgMnlT;6QO6;RAN7>UMd?[Zdi=:M[[2^g/^1UjmNlKUbZM^m
noaEUj]W[SUM>gfMOKg]Q_f=eQjkWYIOk7iYjKG_KKgYL;?mU^>]S[h5ONOjGO/_
g_JjONF>oidK0h/6n^h^_W_oG]`mjGgNoM47Z@mN?laj>?eXoF?/hj8W2TlZWZXo
[OgEn=MVZKgdk:3GH<ncR6N?Q[Q3;onEnJm?``G?ZLl[A[A6jTN]Aln<nHcMN[7d
aO3;S9OChhFo:OjfmiGAZimnMo^mIf;9a?1[dN^I?d[NZ;hin]KfKNMTj>CCMfW_
YZN:gZ^n?oJ1oJ7kHoC7TNW/CoQ?UIn=?gMl2OcbN2I]I^KOmhCcn`YUKVAcM79U
HFd:IFiTKf9Z2S4a830PKf9Z2S8f<C8:IFiTKf9Z2SLP<21_HVX:Fb0_BD=3@V5c
IF@P<C0P<21B85d:IFiTKf9Z2S<P<21_HVX:?3`P;eAiL6DP;e1QIfEc82m=IFAY
HD9_N21K<20`838h=B0b<CMM82m3KgE^M20a82m;JFAc85/P<R0`858PGB0n?PYU
KVA_HVX:<C8P<21_HVX:?3`P;eAiL6DP;d=QM65/KfLP;e1QIfEc83<P<21B83hn
2VE^I6mRJPXi830PKf9Z2S`l82mDNG1U82m6Kfid82mCMF9dNG1U82mDLWEUE7U`
IB0_@V5cIDI_KW@P;dm1CEUI@b]1LVUQK2e2KfaTBGAQK6USCE@P;dI_KWA4IG=S
LVU`M6mb2S4c830PDR0_AFiSKfAYKVLP;deQHe9_KF5^AFiSKfAYKVLP;dIYLW=d
@fQQLR0f=B0_C65cM4=XHG8P=STP;eMYI7AXLb1K83Lb<PXg<S8P=c8b83Lb<R0f
=SLPGB0n?PYUKVA_HVX:<C<P<21_HVX:?3`P;eAiL6DP;dI_KWA4IG=SLVU`M6mb
82m6KfidCV5]IB0_Cd5=FEU3:d5bJF5/;D9_K6A9M65/JF==E20_AVaQIg<P>CHP
;dI_KWA2@Vmh2U/]=CH`82dc=cHP<C<i<20a<34hGB0_BGAQK6US@FiWK6DP;CHP
;d5cHfE^M20i<3DP;dAULf=UKW@P;C8a<R0_@f5`B6EYIfQd2SLa=B0_DgAUKEHP
<20_C6EQI6U^Ib0c<b0_F4QUJFMXM20e<CTP;d5fIeMYI7AX83@g>B0_CF5hEfUT
M6PP<C<c<b0_AVm^M4IYK6Db2S4d830PDR0n?PYUKVA_HVX:<C@P<21_HVX:?3`P
;daUKVMdJ20a=B0`858P;daUKVMdJ34P>3Df<20_AVU/M6Eb82m6K65dIDAUHfmT
IB0n?PYcM79UHFd:N06MFG]P5>Fe?nNKVIgM?3LQ99/4f5dfbBjk8@V1@8189Rl:
A4R005TTI/=3RO883k5H:jQE=5Z=fUYlaUk5F[P]ThgR9UR9SeJ;FWcfF[E:Fnce
QM9Fh5HQNglc/b3dN^lOMfK?Mligc_VnkgcW>mm[M_?6:eIA2VdWRK@EJc^jb7cb
=P>=GK5U/lO:YnY4=_fB[T_GF_V/297bmJE[]UiRiO<NPgc=jUDM:jdlW@:N_1X<
:lnCP0]F[mglGB^O]`cH]FKmRX@lKbObJF/k_Y]XWmi3g[>^HndZBmmK3ecL]GjC
HALNKaJB/Zj=Za;jg4ZD//@DMEfVFOQBSARDSOi>EKB451;TY59J1<_;AC_9b1]b
9GgIRXO^7Vi?[cY^ckFKAAnNOf2b@Ocj_^F;_kkae>UT]kd0oW6HnXH0iM@I`o>X
;VWgecMn]B3ICEiB3L7IamKGD[IOVPm=CFZ:CYfXaJBVO^O8L^3VoYA<0lo];ieX
h^P<@cbg_f6fUFdf/m6U5UXeLK/Qc<ngbVAVFCPi]CbmIZ@dUkH1_P18E8fd2G0k
80j@:AfY8AOBQOdleQgiUMB8O2=j[TVcnn_Zb[LMT6IC;n030280g3;CZ=Wm5AE6
@k?kBbMHf>ngl=Q2=9`2mF[0=/0QP55L<H/kAYBGeWRU>A3=@C^g8cd0>0Ch0?05
@85MLjPDd0B807X15]O@<JbKdcm^V]7NW7j[`g?jTigUcCE>JAHZWXD2/f2^TC:Z
WHEZIiW5I_DkW>FI0o4QlEiDZbVgR:UE9_5nOeE=nI/e^N9m52XCki46J0I40:l2
3P>>0C2BB7/03`5dE2E?jJTI:ei2^AkaXS6V9ZfIM9U9UiVdaj@m2IeMa68GKD6I
Ae3C8bC48eYQnf7KHEDL/1e@aEkKGUGdfWYEdFA[DTFj;Cg1BjmYTf[QX5XhZ1Jm
[3F7/QHN[jEf`5k0420>/56YV4cK08;BTKX11ZLJd0Bh7M0;>02`dejTK>ZMdFT7
Ia/P3[2ADe@PEf7FEH5j:^2H2WSJh;4Y[@KEI?2T>GQ[YEXa1NmT_1FR0Wio>NZM
I;[kYC?4`C?4Kll@;aY4;3kD_cJ_b/@OieDHIORR:0Q3L7D2KdWPB0:GF3PJW3@A
J]7PA0^EFfR2QLX/E6ZQX8G6FBQP8Jn5LRbDKJ6A5/Zbd0P;IEXXeD8Y5TXfD7l`
HHcO</I_6N>gS?5Ka_P]HobF<Gk;6;mUS=lbaVlIhkN<lE_6n2eSo9HaO//H_fF<
gc;6KaWS]hca9ccT=C16XJ327A<_FNRPQGi[XANeI0SG5UBi?cJDn2;=3G`eH0/P
0RP1105nP1L@TjZS]hd3V]7_lKWKJacB1K@N/0e`>d2FY_Ik_6hgeZ=:Q6dU0[DB
XE^9/>e5^QM`022MU@VYHQoZ_Kfj2^gWkX<Y9heV^=ndT?MHJ;655UTXGi/7WJl0
W`1N1e`9F0MH0[P@D0Nh0501V<:DNIR?/LS/h^gL`a8c>EQP2^CTH97>c;1[ndDf
:8Nh>MXi0Vdo4@eLRQk`haB@VMcLcndVeZWCa7_8chGPk`IN3?a_dN23:=HK3IH3
?A0=`T6l:QXH3K@b6_00[HP6bX0jXX4JX8^RoPOM=@iN@WjkdL1R2_:m`8^R`I/Q
K[7@`VR`3SVgEL>HJ>0^MddbSjI>/@NjnN@gLBh5aIjXnb]oC>JXnionV=Rccgdb
f>Cn91Rclckgal6]k[L2<L5J^__=TUOL[g]OLClG:7Dof`U=;MTme?V:nfVXmaFH
5M`KS?5R/>l9E[[_228HB/16oTXDgA;Lhni2EFQ^_M_DG^N=lKf@[_GOiEhE_=HM
lB>ocmdN3;ZGU<Bh<>YNP6IPehG8;MkWKTCS/a<=ObLHL]NSlC[3cZRk9V3FZ:46
e_;M5gR?^:O3QRTUnmdE`NW^2BE7g;iPPg]/9bYjd[dXeI7ZV=8CHilfFNgiXmZc
DNeIY?I<DW]:eIj@fU>TmQBZ?F?DW]5ZUSgCk[BWfE?/BGJkgFJGkL9>mZaHo;1F
K>cOFCJWPFbbTLXVkA@6S@@Y2KH;VT>InPRYDC@^[=D[@hda=Ki0Wa9Ze>g=5kGf
<MlF=[Sjd0YZG>kACbcdaCQYoU9MlMFbW]U8SBfe;UgL56=ZJDFD6`E^b=LcjeX7
R3WgQQoV9g0hG=LjR3DjVgQCV;:gE;^Z<fMTC9eIobe9a6A6jT?O?:i_b52X/GW[
0<;T/GkE?EU5MR6b?DJfalRjA^]g=bi/eGN?3^_U1Q4O7FkDKekXFMHj85`R^j5n
@>@H:=`j8?L;El<2PbogehO3SAQRDhllh=L?D861X9MV9hnQAihd^jTWmUQjKY5S
j0D<13gG;W:KNVkG;U=?IT>_[m?CD=oW@@8M7e6WZM?YXg=d1[RM2Z1EP<C@NXSK
3Be^mceTJ>TQ/b:o7bXUB:32XlQ_E^CWDJI:aCLZgXA:neVEMU?UeVmDPYJ:Q:U^
eB;]Q/ZiO_kodZ]Z6cXGeW9SLf^OWF[3MG20PK>MGC?<b4S=WK4[Oi1NUcjUi51H
Co;Ej/TnK?cE[Y2cRT_KD22jSKT]K59O69@]AKM1C@DH/CGMjkXVOe0VO/b/8@G/
e8AXO<gh6T>4V3LZC`<k?B5bGC?MVco8SbE4C[0cd>jgMG?CY/fQCNL:_UG[G8Go
WBIG@fNmmC<X0e3m5BI/g[CIN3Hee>>gVA[eh<96_G;nd]HnEFg@]DQm6;bB<ca9
<WUm3PM`AgehDn89KKiR<mZ7gk@96Th=6Xh<F[0L<05@1RRMZ643ek1kJmRj=NcK
6SI]3C_f@cE9iWW^8O<lef_B_N95KB9[`B1:SX<F<7Ic;IP930P6P051;f0dC]1n
<o5>?<m9QVgW>RE<8O@J77CiRXAc[`SaYS?//kZK@j@<D[h9Se:nG4CiA?4?cl3`
iO4?3MW`V_R7hSnaSXfb874[^HYncgifdG7>Y;gHDPkBho@f1nUZNXEGDSKUd2UA
@1iFL11dD@_]YX>/DYSjhaoCHkQ1OHIml0hjc<FdV5kV=>cWRnP1V/LShg_XDaKa
`jQQ6SES`LUB]RQ_lgFT/2A^R9MB:TYNCeTdPnjW=oQZaa?a]fP:oDZn<?hgf/T^
4J@djZ:odS7H=eiDR[KhF^ZPKO@<fj@jiJih<JfSDm:=lHMQRDX;dFhkGD<o@J/c
N4S/EEKB::ZVFER`ffP]?DZo49LXalc5_8SF`?HGj2?n1Kl[OBCmDkK;5l^g:XG3
eFQc;4fTB_B/WIKC9[ZEM];CC>cV1Gb?DWkjF_S4@dDd0C[KjCZjVOXQCN<<7/V;
n@5aSCPT?YMo[[`M?`B]BK@5=Ue?cm2_jE?j>m^hQ<_h>QkPe`B;[N8[bA>Wn5<D
X>o@0UY6Em:ee4?gD9BNPSNO4G>U>^U:BILoUKlNOQhglZF`jG_DCknU]c1^VCa:
58W?9:mdPoB`m;9d73dI8El?gL?XAAU/_13_@_Ao4ee5>nPfnRW]XGdd27]NYMOX
GOX@EUObiG`e?lSkn@Ao9KaR[:PBjlF?QBh6aInUK6Vne29]T>jFkYEn8kdQIlRe
LZ?lP;a?O/Lfg_JAfS6lJoP_lGWae_RelC_Snn??a]n8OhiKLBX/l54aML;G6m2_
KO3T;nUY_2oBOm0Oj1gLiSm4e16WL3iGl1aNb8]h3FoTfoQfoQ7_i5ockdBBb10S
AI=X5YN:6lF;hY0dEIX^aNB0G2hgb4_UbnG=lXe:>MjibZg:HlY^IHmbC3UUbkC]
a/knl^WPjON7E`m_6OiS?2VN5QlC;h]gaXoSEST6XmM1Ul8Wml4WSb0joYf6j7Uj
6Eii4mJmAgnTmnT3F?P?>/EIW<d^_?ULS=RJaiOaMoUJS>9>_XlOiWdLhjOh>Gj5
GnGGn7EnVoo4OnI?n7<n9RBA:mc29d:RGJ`Ffo3N:>hBmhQkaD74bB7aZ_Rmn4PL
UIcBF0UWI;aEDPd^D=gB7^UENJBL0flgbEO8El7SSlY3lS?bJo9O55:LbPRU@2UF
6YEKU27U1K??JCJG[LRfcWJmk@NfGKJH:Z_IjVCe>_EVmCkeYnZKmRbkcoj@OCmj
4N1LcT_<Oa=a:ol69o8;>L`k^8EC^I_3U2E2m5=iPiPSgbm^5cQJ6ZZfZK9^H>WW
M9_48Ug^TNkP7m4C>4U?Yao`3;ZBklA8ohJk45g5M:md@1XF<aW;0So2UGA2>XAe
jBehJa9?h>o@7?6Ro3_UQFDkA86hV?lPGfacb;nQ^lAn>B9Gb0cOK/FijbKYQcBI
?YLfBDL`:mK:?IRAEk=<5hSYm2G`ka53CRhD9EC=/jELKYH^hCcddbSk5UJ9C]4W
Z^UioY6hG0[`mkRLS]<`mB_?dCg:0_V]n3ciRKP7W:^<W]5^e8<nlZeBA1hGGc9l
TWM8;_6<E2@^h;o;7J9cn9OLa9?4Qm84gR@flmNh5@@@@@O5G573NKSCYj;nca13
YnQ_59G_TWhHOeoJ<caO?4D5bS9j7B^JSNJ;@Oh7_H7em6U4QAe[kRoTbOB4]8j>
BA4A4jOiY3Q93m8_/@[_5GinEfQde=H^7nH?ejOa6>TB[6V2MV5EGRimCSGa?n64
]cUn:7j0lc5O1[4^oDeiCZbW>k5N?8dEiAZ/Haf8iSFD`U/a0m;`mR?fohke8@O3
Xf0=GHMiNRoFbd6/5fmQeOP8l_OX1>K^?OB^H6Zfg@o;Sm6cj=mGK:L1:/NNTHJi
M2An@WhM_W^LKYJHWU=7f6K8=m:_U0?Z3=XMWh9eOAf=Xk]Y7klS?dI?JkD]F_F<
2jZVCi]J>FEbaJB9iA?:BT_65hN2h`;nX/82geR_aceVm:Sl_5aGC_K8[16I6Lkd
]=BDi2B7GKDY/PASRQ]l<b<N_BRRbdFnFK?66gUO1aPMic0R^PN/VNO[j1jSG0M4
ifUZd;cTGc@eBe<kZlU>CaEESBof=?PlnR_e?Tn<Uli_1Og3NUoHXalejKTV;ANI
VEAT_5jDl3BhE]MkM8ih6_BIFeIg=dCZaaMcGg9BWJm^EM;hH^Y;BPJI34[?lGGe
LLh<=PTLUZOehIJJRSkZNKkj1SgGQj:XARY/j5RY=lm_KJS?mg[3hh]e[U_QFjjC
LHX;VBYDIcJSfnYdeFc6dhVcT4jgN?Z:QkY_SCUYNBBD/]:g/V=IZbieX8h6?B>4
M^_eW:^>^;k9XW8L9GNL:lfG^Q]LWAi3^K]kQdLOV]mjC]Ul[e53>8`jD5HDcXad
cdCC]f:Xf5D:h`ccSJiHWE[UJc0hTL/l^/=Gje_MOET40i;G[M>2[MiXGYhfP;=4
GX>W^jGEimF[lggQS_YAOEWD_F1[OjkVbCeO<[jhciUQNK<_;Ce1Y:BNBjb2YbfI
BIWZ1]Fhh:`kfK38=a/7Bmfc`P=;FWgXB:FA[:ZTkQFEl3ZN<:>D_Q;3d:TkjR;M
cVT67jiTGBUdnScMa`W3kS_jfOVLSPC7E^PlCXK@28jc0JIcaaUJ3hGdH=282kD>
0`TKIiSiR_75Ff9R/Jo;j@62njRi5LG2dd[QLjoG6=EKHQX]AdKO?[oEbW]XNGjD
]58LmTG4T63D;<W8AHITnaW9fN8A7l;gLN<2C2=eNm7IGkXcNdC3jVTjIolOhUFF
_76Q[a77M4m3Mb@AZXd]inD/^N5@n0fb1<EF@CQLU`]eFn5/7b9^`M9FPh6ODSSC
em0IVHDI1Q_e4GF]D[h`iP4XTBnIEB5/UbdmDinAJDdajY8;KDH?<GlTQ:g9H<m<
gAVIIJGQ9:lg<JWnIiVHJSnWD2anc2QUXVn:9KZ/C`/U>VEeDImnG_hlje:jYLHF
;4ZR/FEYMgOBNK:IF>jj^fOj?3>k8mdM/OSfiCj?dmLmP1=RGGMG0aHZJoASlL5K
l_FI]hKAUMDl3C4^Z;K?acO=km?hYXE;F`O`HL=cDd][52O@^TQ]^:l0/]H13i5V
L/EI[Z7S<G;Db9PEDF4gAOT36]5fDeLf6FIn1KiYV3a;2CbV5C5QlIbVGSPL7Xl=
RdUi8OjalP8]03`;22^;LK<P28`H`ilfD3;nbjW1[VAlO95`>eE<2N5/oQkOQe?_
cbCSgaS/0oRcaQ1:f;nZ7QOlY4f=RN>JRaCiBHVBE?U9YUbkCGUBB;[S`?^h<YnX
>UdecoUUeMcCEE@=fWT:bH@bKhHgXa09__c@:HldM4YCj6_bb4=X1CL<DUKP5ZEB
4VM[;AlhF4]QCdYGbS_BVk;LU;9E?Y3bJ/Za5:E82/X1af9YLM9>nBM9Z/=1:K>Y
dCK7[ZGHb>i@>LWQ48[==UIeI:VZ@iJT/L:A9HC34A?QZ6a?R^4^VHI_@I8R2i^Z
2/U^RhW[]6B?^TdEcNX7ZU3gldPL/2DAeY;LXUAdRL=2aXUQWiI>3/gAiGSE8I?3
jA2>Yg3BBAIAlBBi@[W>;m/fW6Qc7CD9ee5d_LYIEEfE>KGDl<7A7DY9j?_>igND
^0bT>Z^ZMSaOeFLCMBf]V]>QINA>LP@L:I>J7>a@I<k8W4Y]XE1h@QU_J6_K`1]Y
0g/U;g]7N2F9iJcCnoGQPm85g?Cil9lG;aYnT>^7We86_iZ9Jmblde5S]1K0Xkn4
Ac=a5Po@JFf69lR;WO`HolcmD70X::m<nHW]IoAZD5hbHXTkTW`/:8NBoBUU@FU4
`3dV>L^OK7N=LK_Ma0PDcQYQ^2g7ObS00DoPPh0X3C@5m<1@@0jhAhn1384Ql?4E
B^<c2AmJWJj0aljUm_Gh0_QB@D0;<ZDidcaYIFVA]=jd0fUZf/EM@@j>6AAgh/nC
0ReS21LVDDHJK[8BEHfSW46aFbb1Ga5?KA]>7g6fWFSKN1@^?XY_<VIH6J6E<KE]
@nT640W_VWj3keBU2Q77KGRXSCM<I6micQPa</^VI^>dHi=md/CbbCPG5OV;O3k9
Jm4nk`:Nb<LO[UUcmkbKK]^`kNkQoo[`d5o_^jUNVnjmiY?O/No9kcN^^FIhYc:H
U;kdkX^^jRmamjkl`M7EdVG5:jMFcTZaWO:G[ZVJgFk</fOSOeE>:VoPBd5D:fVR
9]KB]7AIcLW92CU2BJ6/FDYCnWNbi[S2HZVd=>E^AbXVDEYCNW^jB1oTGe2VN4U;
BYI:LKoFh0n3U@_F==U1POElP4DC]g<__ZmOVah`72_BG]96ln7Ak1V]SFhN7AT]
Slh>J6Zc6U4aKif8jIRh]goDe79SN/:7cPe]6km/Pc_K4:NWSkAEWojbKB[lI_P<
3U=/i?=@aZC<PXWULXiBE>@KJh?g/^4dnBX^2`oOolG`?hIONhUG_oTi5nD=On2j
NN?gog3McjnihSWQ;3Tio3GGljB_^?Nmn7^S]VoJ>Ob[WnY3>k7>Q16C;b<V<lQ=
mfUSKg3a5:[8K<aIT[W4?CQb8>OPb8?I3WMVIR;ZAV@JTIE1mS5VI>DQaQ1I^@5:
LRJ9Y3c=bah_7l2TL3n5<<[4Ia@FmOlJBQk:RHWMONRifODSYho<LkI]f7RRKNii
TI@88</1E[c88k>4JU=]?Soj?FEbIR9L`PRBFgJEG7Ck5H]:W[Rilm6;Wg_dWTMo
?2=leJXiTfkHZ``ZS/YE]`f/>cYlaiZF@?IWhb[WLmZCmcn@UfW41EIQiMO`@39m
Y8FF>7ZUG[DgFIk/d8@V;I5U>g^B?<UCB5K/3UUf>1:>/2W6c4YGkJGf9[]^7l:7
MHLT9jIM4UJf5oLUVk=>7AChLa;odDf^/1UT/ZQm@T^:`5_6A9=4[CJR6ChDCRa[
cD;^QDOcDVG3Nhi_mej:iKdeig[_A5_Ka[U7_V`klVGXb;m<AV>YBgQB?C<3hD`E
BiL9;E`^EdllmLE<LG;RJLLbJM4TIO3hL?oahHg7/@_Pi_XU`8o_5moff<0/X49l
mO5SAC<No=d4<1hKiA8eeLc5Ioe@cLK>SSGSJmN_FCUkLlNJcQEcFnRo0GCZgh<:
IFiTLgAbIF5]2VE^I6mRJPXa=B0`86mRJPXe>C<i2VE^I6mRJPXh830PKf9Z2S`l
82mDNG1U82m6Kfid82mCMF9dNG1U82mDLWEUE7U`IB0_@V5cIDI_KW@P;e5DCUQB
Bb]8IFafIGAYHf4P;dI_KWA4IG=SLVU`M6mb2S4f830PDR0_AFiSKfAYKVLP;deQ
He9_KF5^AFiSKfAYKVLP;dIYLW=d@fQQLR0d<20_C65cM4=XHG8P<C8a82mGJFAd
J7<PFb0c<c<:<c<c830P<20b=cPP<20`830P=CDf83De=R0`830P<20`830P<20`
830P<20`830P<20`830P<20`830P<20`830P<20`830P<0X`830P<20`830P<20`
830P<20`830P<20`830P<20`830P<20`830P<20`830P=CDf830P<20e=CHP=CDf
830P<20`830P<20`2S0P<20`830P<20`830P<20`830P<20`83D`<20e<30PGB0n
?PYUKVA_HVX:<CHP<21_HVX:?3`P;eAiL6DP;dI_KWA4IG=SLVU`M6mb82m6Kfid
CV5]IB0_DEA>F59;:dQUK7IUM6USHB0_AVaQIg<P<c8P;dI_KWA2@Vmh85/]>CDa
82dd>34P<C@d=B0a<C8bG@X_BGAQK6US@FiWK6DP<20_@G=SIFid83Lg<20_A6Ec
HfE^M20]<S<`82m3HG18IFUWJ7@P=c4g82mCM6E]ER0i>20_F4QUJFMXM0Xe<S<P
;e=dIFe883Pe82m1MVMGJFAdJ20d=34P;deQN5MYI7AX834e<30P;dI_KWA6JFaU
<R0a=b0`858P?Sh:IFiTKf9Z2S4g830PKf9Z2S`l82m<IFiWM6PP<CPP<21B82m<
IFiWM6Pa83Le=S0P;dIYK7AULR0_AVaQM6E4IF=_I6DP?Sh:LgAbIF5]2WP1_EUi
O5=e]SoW;[TgCFRC]=WJY4VhCM9mYI^]m5;BD[IJF]06:KB5@V6X86:ec/2[2bhA
6AEIA9k:S0mI1[T]?0bP3^?P<<j<RS>2nh`X>ShodnNlNLPhJ9=gKU8jU<oXQcml
gY_c>nOlcVli_nlinMgLGeJ_^[T;aT4o/=0d]f?UHXQMSUg4?USHdk4b[Y/n8?kL
`]kEk[S>I`:`baN_G=8CelE701:LBiKgSOA??PPPK^g^jUPD]l?Ga<^jZB:^h`CR
6MdmZfn=jbIZ3kW;Eb`L/BM_9mgFdg7[b?c`7^W^6cYj^^;]7GLAceRihZKE8oX<
hQD[EgF=]<MFl^le@:[E`L>PQAn000`Hj6h343i=L097E]E>Ef?X^LLG95Eo0DHa
YRnHnN<HOo>UGGMlfOFeGoN@n0nZd5i/[g9=ER@;@8mT7m8m=6Z9mJ=25hJFW31<
9JXQ:RG:bIUTPgkL2@lB?DW4`U:l7oZ8kR=jU8PKUGJCMQS_7nA4n@Sf@BY>TgFL
JgJ:gFE;d;Un7dK=`LMMKm/n>XYfR]hI]0n>0nfT17`BWh15h<;o02oN1Pf@RM/>
I2eg]I=Y=j`TjRMRHbGRk/7dH]L;V0]N3ZV?3m8i?>CjLe6Njn>R<8>3[QOmHHkH
;m99Ti=Laib?^gk^G>9jPFQ_g;@WReXLL^ef;WM]C0oS]T7G`lh`DYn7h^aV9gDm
i>[9f^aJE1BccmPLI_H>^R[9OZf/LiEEN5bUc[>^0WmHA=;cW3=LfDF_^3:X8cEc
dj1NfNQb>3Nj[R9C^[?>OaGADMb3Sd4f?SKXWNHj@R8]ml3D[8[=HOcQPHK<8VlH
Ki?;6S8gIcGh_ETcG=j/N[nOi6]o;M`UG2m<4XZ5725Cl0TN8De84DfR@D`DmF:2
:8Y267lfF>?B7<FmD4>`k3dPJT@nS<m@9GLDmlDZmcd[LR8SPYPBSWi0bH^@4/Jm
1`fZA<8QCDcBQ77OPGSE?]W5ZA8G<aPHEJJ2BV1@I60J:?Q0F0?[;;de]Q[CA6=U
ON2KR_JHiF:IllfG3Ig:i^T][LXNIe0YEXFX<gRa^NfRl8elmLeTjZ[=bIWNg7NP
MnFbaGEMDUfkE=M5e:kLgm]]DoXkgNj1IB]EPe]QONfM2k]Eg]6U[9Bj0/Xb:N0N
j8ge^lblF3GgBX41F5`g^gEP/M`E6>bENn^TST3`@6O]Z[HaLmdg>]NZfWlaEjdj
f2Ye[/iH_l_VJU?=WNYLKNYLKNYLWG9WK2ielGE;FfY_FTgIjJiK>]f]I;HXDfO=
KEGL7L5067MBIN1Vh8n1PGlN<_UnB>D:`0D@OI_X7IE7iT@ohDn08M8CoAnfRX9j
F2DVDU<=an01N0cfP`IfTI`9lf4[_8c;j;/m3`k2JDb7O=Yk>@S33?PMAZ>_`f9h
R]Z_QQMQ4`b0W_[dP9V/6m0K_HedVNA>^2_j4lR02[PKWXM:6WD334EgA`n@]AWV
`1kHBoeoRa8c`2E7WhVN1A5VdIQgTNGej8cXOS11;]A24mGN1BnPUgdWfPdfZ2;_
]/<C/0=n0Go1>o1P]3_J6cdI?D>YJP<7]=2m1PoR6GHoMgMdNoBcJ8B@b8A/V[DM
=/9?JOcmM1nS[KD>Oh2[LB=^HVCV3^HP]hjgAXH9QbbH@WL3[81k2H73L1cn1_o0
caTKJf1G/bm5Bj?oBg_fM5ZU^Y8^j:Gk7[Xgd9Z>XPH;LC8fhAYl13OQ7iQ/IPkC
b]c2g<Yl`SJblmPnmPoLCM`P_ikOZ]55_XPNSIj8WP8[>>5jF0E[JGD_`TTh1aN@
YK4Lj<DZ[<GiM?OSHlaQg867VBHlQRNI?OPWo0PoajlHW]4cIRJ7FLe/I?Hb;c:_
/T_ICNbSk9oH;kR9?<?_h3oFN8Eg8ifAnb:_AZ^RIj9OdQH[PXLRD`^=/00jJ;D[
H@;l6jeR7mgk:F[7hBEh>GIoQ0hHPRl91D0CYV8acZBk4Jo1aKPD7lLSM;l@lnDl
@h5P]8bA/C8>YXGYI7ZHO^HDdlnV/MW/=7H^^io^Gk>WfJoH[cRNBnK<g1A^:ZcW
N[Q]M>oTMW63g6]l9CnAKnB_iO_inoSek4;nMOjdIZeVPfI@lkWV[k@]cQ1F2>/Y
>RmCc_j2L_VO5hLIi7dag00;<H2M/9VR/@<k84CI]@S_9KaF@VJdSEg;CV4::A]N
P1mB]Vj3=G0O>`mfA=mRml2KU2W;JLQnN9Z[1BNoQJ9c1aAB5XgLLUIfEZKOilf@
aW_L]>DkdU;]=Z_5W99/<Q[6jGD9FU7@l1c;8>CFBOG]K/GG[W0nZJ4QCmFU3Z[X
^:BRWKk:KZEnK1_5[OK[8=>HUS:eG7aIBcWNDQi]R@Ig=ECWiK[[9;ObBT1bQg7^
[5JB7`Q8@KLb59=Wa^@7Ho8hTSdNj^2^/gD7g0Zf^n^Dn]k^D5ek82lG3l/4Ad9N
[[Yab:1C1eIPL/LJfV1Q/]ZRCTVE0WF:GB:IK:bg[V>AdSB[]Bj@i_44ZHjZVU]Y
S[cLY@[i2OO[5dV;kPo;d=V^BQgcFQFf8jP`kNYHaQc5:PDDjfdOfojYGYCZeUmR
E1Q_ODMGZ5jAfnlWL5FeGMDjeY<f_LE=`c;[PZd:[Q]a@_Ea6GVZ^Q]o9WSKUkTE
[E@[MHNF]A>hd=`jV2ZWaSIO1IYJ1nfb?JKTiAjf[Jgbd>X?idg:VjCb:Xm]KIco
nLihoNn?ZMbfm_P7a:LgS`:0:P;BE?9CLBn<CB:A/aEZdED1XHDEQ1=M@JAU;REo
9R/<i@c[EGS_e0jU_nFR6mf1^7?]b`:3FW]Zk25D6jCfkB73EA@YJVn@g:4_j6WM
;PgmIFa=adR=aV_h0UBS6^SAG56`hj;LZch/_KCZKY_D[LJg=aICdREKgBDEY:_@
Z3h[:O@0Kf[e:>hPEM2_bMcYHM0f]@hPKPR6<KX^307WHOZ=bRjHCnIL=MFF1VQn
D_9bZB;K@e9n[[^NIZiGLlDMLXNV;PZijmgMU4bL=lK9d1D:5Q22;Jf44lbV6NEP
fZSH5@aNAN<DZ>=@5fXN2]88bdI681j[:QRVAXFim31UODf]/eZEoT2J8PN250E:
gf==[LXab]aPT5XESGY:7ZmIJQ_a^IQl;/XVNdUl5?[]dTm314<QMLbFE/VS70^5
dT;Zmbf^Qa4^[i17:/:P=U4Q3f=o4oDU9WWBHS7`B1ib:jQR>X5BnV96dFofKdNh
K=A_jUU>gYK54:khSQ2^_1:4[kXRQ:]6?Af3L3GiG:DRO?GgQo34<@SGO3_2lZSO
i>@TlUJ>8Eck7B4lnDX@3U`A`WFSWXi1^9il[U<AW_;m8M``1^6Yghk`]56obLWY
i>fd6<8c_R>4Ieh9`XeGQ?0eXij>@KR9O;i6AGSFmhM`laR4FkhMhMVSOY>CLlSK
fC64[of>4;k^BQ1^_B:4Pj>NST5h;_TLE16nOQAQ>Df1BoOQo/^fGOS>=nIiUd1>
_iAh4m@bNf03DH2YQ3gLCB0C7BMZ9ZXPJZ2GKAfAVIYO?>OAdm_7<jAWdY]5o>FK
3XU8Ebl>n;S`oeIZHR<;m5i`9ILF4V;=b^RMiASlSGi6g<dd<LnaMk>7^1Wd4U1;
;YnTme6Fc[DValnJa88`L4BR8@a`TTSEBFKO8iVh@9`U[Wd?SU0_P6]cS]18??72
XQ:SanPWZ^DfQ;onT7on`^@`=o<[>[/PY3I4iS<Mo2U8PHVb=/FXCKIH[JWJXkRM
eY:2fnE46OZi6@JkfO9gco9VFePXGYNCdgQ^iU3ZnjU3K``eeWD5?X6JVZ92I0B=
dF2e94_ij?OiOJF6l[9TI_jo5dbIEKbakn7j[0Z;[ZgZ:7lZl]Z3kdK>A?khedLR
WieM^obAGMMMPiUogXSNV3l1l/M:oRA3VJ`GSI1/9Wnh6DW9ZT]dC4L^JDEkR_W_
WYXOdR67j/TK@nmOhTNbZKc<J?3kf99d]:JSfB1Xf2U?i=N[GVbKi2_<VUme938O
bcJlRAkdo?DA]9boZF_=^A/SKgfj:O;7V0mk8RNa7mj1A<RC;B0U9R`B4`cTQS0Q
HA68mZB5GKJLA/>iVMG35nMEWBPZ]9JEUiE>l?VUdQ9cRTKHDnM8@ZKWM7__joXi
NMV2CWSW=kLLE9>F8R=7gnHLo5I8XSO_6fG[?CcFRnKB9=iA:X`cEK0[K1Fjm2U>
@nmafa]3`d=@<eA34dc^TbM0fSPONU=mFRo_/bCJ<RUbYTa<4dTbJ4Rbj/fIV<a@
HDm`I8:AXd8m1d6eR5fgdc6YeF8d28c7kOLI9iBK?:Hbh`A66/lHDjbF4UKnDO]e
Jb<OAR9[UmKdHVUXijgkW]QHd?0<_oGSPLS_8^om??;O7ac5ZW?k/Ok2aemRlcV/
RYb:_?o^^]nZJd=jn`GV5?l`II0d868HBf@ma`UjC]S<@l8D[KZXhjN6:bU]c[eB
E9QL>Q7;BhbBlOP_]oTf76??Qi:3>boL`9jW/EQXS[hGNl]=X_>;JWQO[/P^a0B3
;Tg_l9Ld69IZUaV4B]6Tek9YaD:6eVW@>j]bV?b/ZVN[V:[RK:o98?2R`coNjPQS
B9J/CYOPMnK[66NY[UZX[WJT25WI^c9B9jIU>JHUnB_/Edml3[O@boeQg0`SjGE^
Z=5`O^KIhN>VbP9bV@9A<cATZSBJ[9E]AU=UoU3n418gFR]S0LX/:cN?1kAk/Bc9
0kKd=0mHg2VDJ^>QW?50Z]?Z@K>72SDZJ:QF@g;kkA@CK<^`U1BGUef=RIR46T5S
aWPnBN<5SB1=a99RNTdfYU0SVR8AYO7d=E>I[gA2FGTb9ZiZG13Lk>T^k^T/J/63
4lgj>fmkX<ZC/8_ondnOkkgIj]FW6k=cOFgI5VgiZcoJm?bA;J7Gi^I>gOV@fJ59
7>LXF8;;aEaKg[bF6MT]_gZ/XF7[l1K7N9IMYmODBW;3/_nlMm=CbGQFcMf:j3_/
4?lRWN@hhAJi^3aaB^9eRDmc^m=h[iS293T=83ZM@W82hkCZn?cTO4>FdICZd_UC
kNV^Ncb[JTN09ER[I`jO?J/V=gf<ULHhPZTfQcH146dj7fPME82MlD52V^RS7:I?
32fC2P=mfJCa6S=U/mE86EBZXP6U4d`UiaoN/FK7c]_^gHfQU/:[mofTiVL[3T@^
O?i7G?3YVboomYLWOl>DCdROcSP_C=bd/1Gc;Wb6ee6^=DCOhE;YA<E1YfmNe<]m
FlA7Dimf/G`RTlBWV1==BNHDFBnWR5VY>5egR3f1_f9?Y;dU_ZdmkGY;n]CjZJ@k
HCaQH^J9_2LSJI_5VE6Y4@B;anT@4Y`FWEOHhWSJlJcSC@OW]BAi7K`m@BlH4oe9
CSnOj/o85oaf^looQVMWFabPhK=ZhPfm<EaYZZAdZbAFd1K?@9:ZQj/=@e@KBkYj
T3RNYN<Zi3V=bfLdV0c9QQ@3Ym5kajMUn<0=CQnV>kEF`@LjLj8?abE:ZAjZhZT@
K@Tn66NP8[iAZ3TIbl_/W>cKlLHf^;6]3Bb4/LG/BJL/;2l[;dU4bTT=XFdd@0WB
MTma490iN;ZRc6ChnW?n`Bd?c2i<6A2^:F[^VmCljlQWJ?/@GK[<JO]n]8]7RI_b
PcVcUTokbDmOJR^KD_E@OY?3P1:MfC5H6o7MG7o7PA2ZO`[AGZ:SCN0<Ed1LPX44
/DKAU0b0YTIQBe3A5bSSC]<iJX;A=<28UIF5ALTUJFSEXT@OC?n_lomh=k85ncj9
W8m4cV8OEa2i1o_hhJn6glF78cL`m<1Q`1bIbWi:<KN17GhSga0bgf]kf/H:6Z^V
`]APJSD]4FiQKa7FYfb5;OaFlaK;5^/^f6Da=<1dlaC[bfH^`?n:InkQMl9>O9[O
INDc<WVKfFY1d9Se^RBWV6PGk7I;6SdmN<3mE[=]_ok75W]ZfQ^N9F/Yc7IjP9fe
3EMFd/LNNiSJh]_<c>7:HW^1[JJj^YXRSgA8;i_<I[1HNTaFZhe7k37AWfSgi>LH
eQb?<I4h]]eHE7PS]]5VDZ9Q6H6Q2?WlYF[@b/YYUlDBI5W?2MnMWKGKnkOk/]8;
/Pg51@InHV9TmNo@QEc1T/Q3TKll4eUlD2<n=DkS/HV?I72=GfmUke2aRUgA;SZg
oELGAHZRY:LWFS8mT`:aLn3[HAkE8Ye8delQM6WX?cZH=K^a]GUjCT?Gl]j^eD/G
M/AJa<aDZ?lMbTA=A>e4:hWjRAhTNY988CY6M38jLY4<Xc;Bkkna>_f?=lJNNiUN
N9UNM9V^NWOYn8/^df=HG3;o[IOIneCmo`0XJmPl2VE^I7=dLVEQK@YUKVA_HVX:
<CPP<21_HVX:=3Hi<@YUKVA_HVX:<CTP<21_HVX::6eQHdmC85IULW=YKfhP<C0^
<C@^=R1L:49eJFaT834hAcD`<c=L:B1AMF5bM7XPD4A6@fm^M6EhM2T:IFiTKf9Z
2S8`830PKf9Z2RQ4>S8`<S0a<C8i<CH`<c<cFS0`9c0`9bT:IFiTKf9Z2S4P<21_
HVX:?3`P;e1bKfAeHfEb834i830PDR0_@g9UHGAYKfi4HGAU838`830PDR0_CFmT
A65dIB0b<20`858P?Sh:IFiTKf9Z2WQbIFH:<20b<@X`<30`<30`<30`83He=C<e
86HP2S0`<30`<CH`<SLP<30`<30PKR0:<30`<30`<3Pg=B0`<30`<21^80X`<30`
<30c>3Di830`<30`86hP2S0`<30`<30`<S8P<30`<30PKR0:<30`<30`<3Pe=R0`
<30`<21^80X`<30`<30`>CLi830`<30`86hP2S0`<30`<3<h<S<P<30`<30PKR0:
<30`<30a<3D`<R0`<30`<21^80X`<30`<30c>CTb830`<30`86hP2S0`<30`<34`
>3LP<30`<30PKR0:<30`<30`<cP`<R0`<30`<21^80X`<30`<30c>C@b830`<30`
86hP2S0`<30`<3@a>C4P<30`<30PKR0:<30`<30`=3@e<R0`<30`<21^80X`<30`
<34`=3Pa830`<30`86hP2S0`<30`<C0h=CLP<30`<30PKR0:<30`<30a<C4`=b0`
<30`<21^80X`<30`<34e>3Ph830`<30`86hP2S0`<30`<CDi<3TP<30`<30PKR0:
<30`<30a=CTh=B0`<30`<21^80YdLV5YK6Eb2S`l82mCJGYU838a82mBKfmd834b
830PDR0_BFiVKb0a830PDR0_BD@PFb0l=S1U=S0e<68iIS@hHS@d<C8g<SLe=cIV
Hc0c<6Ha<3Dn2S`f<6Df<3D`HSUV=3QR=3@a<SLb=cDg=VIS<3<`IS4`=ChPGB0n
?PYcM65bM7QbIFH:<CHa<38:9BE5CdH:\>"], "Graphics",
 ImageSize->{285, 217},
 ImageMargins->{{174.1015625, 0.}, {0., 
  2.2421875}},ExpressionUUID->"6f6c173c-f9f5-4fe6-8558-84e3a967d7bd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Find", " ", "coordinates", " ", "for", " ", "E"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "start", " ", "by", " ", "finding", " ", "the", " ", "equations", " ", 
    "for", " ", "AC", " ", "and", " ", "BD", " ", "and", " ", "then", " ", 
    "find", " ", "their", " ", "intersection"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{"x", ",", "y", ",", "ax", ",", "ay", ",", "dx", ",", "dy"}], 
     "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"equationAC", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", "ay"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"ax", "-", "1"}], ")"}]}], "==", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"ay", "-", "0"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"x", "-", "ax"}], ")"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"equationBD", " ", "=", " ", 
     RowBox[{
      RowBox[{"y", "*", "dx"}], "\[Equal]", 
      RowBox[{"x", "*", "dy"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"ex", ",", "ey"}], "}"}], "=", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "/.", 
     RowBox[{"First", "[", 
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"equationAC", ",", "equationBD"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "]"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.815654846966208*^9, 3.8156549764241257`*^9}, {
  3.81565501364832*^9, 3.8156551744006853`*^9}, {3.850583669667141*^9, 
  3.8505836759061728`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"b2570c19-013b-4a4c-a6e3-3b7cce44cbe5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"ay", " ", "dx"}], 
    RowBox[{
     RowBox[{"ay", " ", "dx"}], "+", "dy", "-", 
     RowBox[{"ax", " ", "dy"}]}]], ",", 
   FractionBox[
    RowBox[{"ay", " ", "dy"}], 
    RowBox[{
     RowBox[{"ay", " ", "dx"}], "+", "dy", "-", 
     RowBox[{"ax", " ", "dy"}]}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.815655042219037*^9, {3.81565511356851*^9, 3.815655151957675*^9}, {
   3.815664250889575*^9, 3.815664268869597*^9}, 3.815664855543708*^9, 
   3.849694988151043*^9, 3.850306687515277*^9, 3.850583710607505*^9, 
   3.851254870711535*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"2d942267-c2b4-41b6-9bcd-86c9710eb281"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Draw", " ", "an", " ", "illustrative", " ", "figure", " ", "using", " ", 
    "numerical", " ", "values", " ", "for", " ", "the", " ", "coordinates", 
    " ", "of", " ", "A", " ", "and", " ", "D"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "step", " ", "is", " ", "not", " ", "needed", " ", "for", " ",
     "the", " ", "proof"}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"figCoords", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ax", "\[Rule]", "0.2"}], ",", 
       RowBox[{"ay", "\[Rule]", "0.4"}], ",", 
       RowBox[{"dx", "->", "0.9"}], ",", 
       RowBox[{"dy", "->", "0.6"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Pa", "=", 
     RowBox[{"{", 
      RowBox[{"ax", ",", "ay"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Pb", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Pc", "=", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Pd", "=", 
     RowBox[{"{", 
      RowBox[{"dx", ",", "dy"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Pe", "=", 
     RowBox[{"{", 
      RowBox[{"ex", ",", "ey"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"quadrilateral", "=", 
     RowBox[{"{", 
      RowBox[{"Thick", ",", 
       RowBox[{"AbsolutePointSize", "[", "8", "]"}], ",", 
       "\[IndentingNewLine]", "Black", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Pa", ",", "Pb"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Pb", ",", "Pc"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Pc", ",", "Pd"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Pd", ",", "Pa"}], "}"}]}], "}"}], "]"}], ",", 
       "\[IndentingNewLine]", "Red", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Pa", ",", "Pc"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Pb", ",", "Pd"}], "}"}]}], "}"}], "]"}], ",", 
       "\[IndentingNewLine]", "Black", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"Pa", ",", "Pb", ",", "Pc", ",", "Pd"}], "}"}], "]"}], ",", 
       "\[IndentingNewLine]", "Red", ",", 
       RowBox[{"Point", "[", "Pe", "]"}], ",", "\[IndentingNewLine]", "Black",
        ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<A\>\"", ",", "Pa", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<B\>\"", ",", "Pb", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<C\>\"", ",", "Pc", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<D\>\"", ",", "Pd", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<E\>\"", ",", "Pe", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "2"}]}], "}"}]}], "]"}], ","}], "\[IndentingNewLine]",
       "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"quad", "=", 
    RowBox[{
     RowBox[{"Graphics", "[", "quadrilateral", "]"}], "/.", 
     "figCoords"}]}]}]}]], "Input",
 CellChangeTimes->{{3.815655196881085*^9, 3.815655665795712*^9}, {
   3.8156556968515377`*^9, 3.8156557838031483`*^9}, {3.815655932701605*^9, 
   3.81565593438804*^9}, {3.815656005926347*^9, 3.815656046238167*^9}, {
   3.81565607933572*^9, 3.815656161061664*^9}, {3.8156610836465673`*^9, 
   3.8156611441494503`*^9}, {3.815661184126947*^9, 3.815661356574294*^9}, 
   3.815662134195237*^9, {3.815662260514454*^9, 3.815662261833972*^9}, {
   3.815664778415156*^9, 3.815664791225912*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"0ec44dc8-aa5a-464b-8044-17659b67bb95"],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0], AbsolutePointSize[8], Thickness[Large], 
   LineBox[{{{0.2, 0.4}, {0, 0}}, {{0, 0}, {1, 0}}, {{1, 0}, {0.9, 0.6}}, {{
     0.9, 0.6}, {0.2, 0.4}}}], 
   {RGBColor[1, 0, 0], LineBox[{{{0.2, 0.4}, {1, 0}}, {{0, 0}, {0.9, 0.6}}}]}, 
   {GrayLevel[0], PointBox[{{0.2, 0.4}, {0, 0}, {1, 0}, {0.9, 0.6}}]}, 
   {RGBColor[1, 0, 0], PointBox[{0.4285714285714286, 0.2857142857142857}]}, 
   {GrayLevel[0], InsetBox["\<\"A\"\>", {0.2, 0.4}, {2, -1}], 
    InsetBox["\<\"B\"\>", {0, 0}, {2, 2}], 
    InsetBox["\<\"C\"\>", {1, 0}, {-2, 2}], 
    InsetBox["\<\"D\"\>", {0.9, 0.6}, {-3, -1}], 
    InsetBox["\<\"E\"\>", {0.4285714285714286, 0.2857142857142857}, \
{0, -2}]}}]], "Output",
 CellChangeTimes->{
  3.815655666593418*^9, 3.815655734990773*^9, 3.815655785393338*^9, 
   3.8156559353936987`*^9, {3.815656028863834*^9, 3.815656046702477*^9}, 
   3.815656084808139*^9, {3.815656137560337*^9, 3.815656164097142*^9}, {
   3.815661113210462*^9, 3.815661145073783*^9}, {3.815661192401146*^9, 
   3.815661249984807*^9}, {3.8156612888751097`*^9, 3.815661325532756*^9}, 
   3.815661357044161*^9, 3.8156622632463083`*^9, {3.815664250954216*^9, 
   3.81566426892162*^9}, 3.815664855705256*^9, 3.849695842627048*^9, 
   3.850306700223096*^9, {3.850583704430484*^9, 3.8505837137955933`*^9}, 
   3.851254870768361*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"d60f5512-047f-4a11-9dfd-187fe65fe90f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Find", " ", "the", " ", "centers", " ", "for", " ", "the", " ", "4", " ", 
    "diagonal", " ", "point", " ", "triangles"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"trilinear1", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", "B", "]"}], 
       RowBox[{"Cos", "[", "C", "]"}]}], "+", 
      RowBox[{"k", "*", 
       RowBox[{"Cos", "[", "A", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lawOfCosines", "=", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Cos", "[", "A", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}], "-", 
           RowBox[{"a", "^", "2"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "b", "*", "c"}], ")"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Cos", "[", "B", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"c", "^", "2"}], "+", 
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "c", "*", "a"}], ")"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Cos", "[", "C", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "a", "*", "b"}], ")"}]}]}]}], "\[IndentingNewLine]", 
      "}"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.815655868803722*^9, 3.815655887915216*^9}, {
  3.815656174908791*^9, 3.815656191006551*^9}, {3.8156562226450157`*^9, 
  3.8156563407813683`*^9}, {3.81565637284581*^9, 3.815656470255536*^9}, {
  3.815664014553617*^9, 3.8156640184636383`*^9}, {3.815664168065222*^9, 
  3.815664168535851*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"c2357f4f-b83e-482d-9bc5-4246c01fcb20"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Multiply", " ", "the", " ", "1", "st", " ", "trilinear", " ", 
    "coordinate", " ", "by", " ", "\"\<a\>\"", " ", "to", " ", "get", " ", 
    "the", " ", "1", "st", " ", "barycentric", " ", "coordinate"}], " ", 
   "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"bary1", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"trilinear1", "*", "a"}], "/.", "lawOfCosines"}], ")"}], "*",
        "4", "a", "*", "b", "*", "c"}], "//", "Simplify"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bary2", "=", 
     RowBox[{"bary1", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "b"}], ",", 
        RowBox[{"b", "\[Rule]", "c"}], ",", 
        RowBox[{"c", "\[Rule]", "a"}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bary3", "=", 
     RowBox[{"bary2", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "b"}], ",", 
        RowBox[{"b", "\[Rule]", "c"}], ",", 
        RowBox[{"c", "\[Rule]", "a"}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"barySum", "=", 
     RowBox[{"bary1", "+", "bary2", "+", "bary3"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.8156603696651697`*^9, 3.815660427426312*^9}, {
  3.8156606473649797`*^9, 3.815660657315333*^9}, {3.815660739844817*^9, 
  3.815660804092516*^9}, {3.8156617064646997`*^9, 3.8156617215349293`*^9}, {
  3.81566175292069*^9, 3.815661824200328*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"c9ea235b-52b4-4a29-984c-be604779c0c5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dist", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x2_", ",", "y2_"}], "}"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x2", "-", "x1"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y2", "-", "y1"}], ")"}], "^", "2"}]}], "]"}], "]"}], "//", 
   "PowerExpand"}]}]], "Input",
 CellChangeTimes->{{3.815660840900197*^9, 3.8156609119721622`*^9}, {
  3.815661517879793*^9, 3.815661546158374*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"e99adafa-ab78-48b6-ad56-17cbf72b5f24"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Locate", " ", "the", " ", "points", " ", "F"}], ",", " ", "G", 
   ",", " ", "H", ",", " ", 
   RowBox[{
   "I", " ", "inside", " ", "the", " ", "diagonal", " ", "point", " ", 
    "triangles"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.8156609506852617`*^9, 3.8156609731963797`*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"04ba5bdd-4f3f-4dab-9c2e-3fe6017dc953"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"lenAB", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"Pa", ",", "Pb"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenBC", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"Pb", ",", "Pc"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenCD", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"Pc", ",", "Pd"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenAD", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"Pa", ",", "Pd"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenAE", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"Pa", ",", "Pe"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenBE", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"Pb", ",", "Pe"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lenCE", "=", 
   RowBox[{"dist", "[", 
    RowBox[{"Pc", ",", "Pe"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lenDE", "=", 
    RowBox[{"dist", "[", 
     RowBox[{"Pd", ",", "Pe"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"centerABE", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"bary1", "*", "Pa"}], "+", 
        RowBox[{"bary2", "*", "Pb"}], "+", 
        RowBox[{"bary3", "*", "Pe"}]}], ")"}], "/", "barySum"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "lenBE"}], ",", 
       RowBox[{"b", "\[Rule]", "lenAE"}], ",", 
       RowBox[{"c", "\[Rule]", "lenAB"}]}], "}"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"centerADE", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"bary1", "*", "Pa"}], "+", 
        RowBox[{"bary2", "*", "Pd"}], "+", 
        RowBox[{"bary3", "*", "Pe"}]}], ")"}], "/", "barySum"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "lenDE"}], ",", 
       RowBox[{"b", "\[Rule]", "lenAE"}], ",", 
       RowBox[{"c", "\[Rule]", "lenAD"}]}], "}"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"centerBCE", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"bary1", "*", "Pb"}], "+", 
        RowBox[{"bary2", "*", "Pc"}], "+", 
        RowBox[{"bary3", "*", "Pe"}]}], ")"}], "/", "barySum"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "lenCE"}], ",", 
       RowBox[{"b", "\[Rule]", "lenBE"}], ",", 
       RowBox[{"c", "\[Rule]", "lenBC"}]}], "}"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"centerCDE", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"bary1", "*", "Pc"}], "+", 
        RowBox[{"bary2", "*", "Pd"}], "+", 
        RowBox[{"bary3", "*", "Pe"}]}], ")"}], "/", "barySum"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "lenDE"}], ",", 
       RowBox[{"b", "\[Rule]", "lenCE"}], ",", 
       RowBox[{"c", "\[Rule]", "lenCD"}]}], "}"}]}], "//", "Simplify"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.815661387716498*^9, 3.8156615010146523`*^9}, {
   3.81566160607171*^9, 3.815661611046569*^9}, {3.8156616927911587`*^9, 
   3.815661699214929*^9}, {3.815661841335532*^9, 3.815661925647656*^9}, 
   3.815662103644033*^9, {3.815662460580462*^9, 3.815662518195291*^9}, {
   3.815662565763628*^9, 3.815662629779756*^9}, {3.815664082697843*^9, 
   3.815664090775828*^9}, {3.815664144065123*^9, 3.815664155984667*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"c7cea900-0b63-49ac-8fc9-c28887904f3f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Add", " ", "these", " ", "points", " ", "to", " ", "our", " ", 
    "illustrative", " ", "figure", " ", "using", " ", "a", " ", "numerical", 
    " ", "value", " ", "for", " ", "k"}], " ", "*)"}], "\[IndentingNewLine]", 
  
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "step", " ", "is", " ", "not", " ", "needed", " ", "for", " ",
     "the", " ", "proof"}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"pointABE", "=", 
     RowBox[{
      RowBox[{"centerABE", "/.", "figCoords"}], "/.", 
      RowBox[{"k", "\[Rule]", "1.3"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pointADE", "=", 
     RowBox[{
      RowBox[{"centerADE", "/.", "figCoords"}], "/.", 
      RowBox[{"k", "\[Rule]", "1.3"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pointBCE", "=", 
     RowBox[{
      RowBox[{"centerBCE", "/.", "figCoords"}], "/.", 
      RowBox[{"k", "\[Rule]", "1.3"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pointCDE", "=", 
     RowBox[{
      RowBox[{"centerCDE", "/.", "figCoords"}], "/.", 
      RowBox[{"k", "\[Rule]", "1.3"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"points", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{
          "pointABE", ",", "pointADE", ",", "pointBCE", ",", "pointCDE"}], 
          "}"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Text", "[", 
         RowBox[{"\"\<F\>\"", ",", "pointABE", ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "0"}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"\"\<G\>\"", ",", "pointADE", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"-", "2"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
        
        RowBox[{"Text", "[", 
         RowBox[{"\"\<H\>\"", ",", "pointBCE", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "4"}], ",", "0"}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"\"\<I\>\"", ",", "pointCDE", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "5"}], ",", "0"}], "}"}]}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lines", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"Blue", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"pointABE", ",", "pointADE"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"pointBCE", ",", "pointCDE"}], "}"}]}], "}"}], "]"}], ",",
         "\[IndentingNewLine]", "Green", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"pointABE", ",", "pointBCE"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"pointADE", ",", "pointCDE"}], "}"}]}], "}"}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"quad", ",", "points", ",", "lines"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.815662121889491*^9, 3.815662179057414*^9}, {
  3.8156623720757227`*^9, 3.815662448706707*^9}, {3.815662687244935*^9, 
  3.8156627885161667`*^9}, {3.8156628214615097`*^9, 3.815662824788678*^9}, {
  3.8156628571094217`*^9, 3.815662886724581*^9}, {3.815662932765666*^9, 
  3.815662935316457*^9}, {3.815662966415786*^9, 3.815663171981433*^9}, {
  3.8156632514395847`*^9, 3.815663481583969*^9}, {3.8156645570750103`*^9, 
  3.815664617305335*^9}, {3.815664815458685*^9, 3.81566481585273*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"713cfbd3-2529-45e2-8882-82288ff468e7"],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], AbsolutePointSize[8], Thickness[Large], 
    LineBox[{{{0.2, 0.4}, {0, 0}}, {{0, 0}, {1, 0}}, {{1, 0}, {0.9, 0.6}}, {{
      0.9, 0.6}, {0.2, 0.4}}}], 
    {RGBColor[1, 0, 0], 
     LineBox[{{{0.2, 0.4}, {1, 0}}, {{0, 0}, {0.9, 0.6}}}]}, 
    {GrayLevel[0], PointBox[{{0.2, 0.4}, {0, 0}, {1, 0}, {0.9, 0.6}}]}, 
    {RGBColor[1, 0, 0], PointBox[{0.4285714285714286, 0.2857142857142857}]}, 
    {GrayLevel[0], InsetBox["\<\"A\"\>", {0.2, 0.4}, {2, -1}], 
     InsetBox["\<\"B\"\>", {0, 0}, {2, 2}], 
     InsetBox["\<\"C\"\>", {1, 0}, {-2, 2}], 
     InsetBox["\<\"D\"\>", {0.9, 0.6}, {-3, -1}], 
     InsetBox["\<\"E\"\>", {0.4285714285714286, 0.2857142857142857}, \
{0, -2}]}}, {
    PointBox[{{0.21031746031746032`, 0.2142857142857143}, {0.5067460317460318,
      0.47380952380952385`}, {0.4801587301587302, 0.03174603174603173}, {
     0.7765873015873016, 0.29126984126984123`}}], 
    InsetBox["\<\"F\"\>", {0.21031746031746032, 0.2142857142857143}, {2, 0}], 
    InsetBox["\<\"G\"\>", {0.5067460317460318, 0.47380952380952385}, {0, -2}],
     InsetBox["\<\"H\"\>", {0.4801587301587302, 0.03174603174603173}, \
{-4, 0}], 
    InsetBox["\<\"I\"\>", {0.7765873015873016, 0.29126984126984123}, \
{-5, 0}]}, {
    {RGBColor[0, 0, 1], 
     LineBox[{{{0.21031746031746032`, 0.2142857142857143}, {
      0.5067460317460318, 0.47380952380952385`}}, {{0.4801587301587302, 
      0.03174603174603173}, {0.7765873015873016, 0.29126984126984123`}}}]}, 
    {RGBColor[0, 1, 0], 
     LineBox[{{{0.21031746031746032`, 0.2142857142857143}, {
      0.4801587301587302, 0.03174603174603173}}, {{0.5067460317460318, 
      0.47380952380952385`}, {0.7765873015873016, 
      0.29126984126984123`}}}]}}}]], "Output",
 CellChangeTimes->{
  3.815663275757093*^9, {3.815663320225317*^9, 3.815663365112501*^9}, {
   3.815663410317318*^9, 3.815663482068825*^9}, 3.8156640957418833`*^9, {
   3.81566425126334*^9, 3.815664269046691*^9}, 3.815664648394862*^9, 
   3.815664856154194*^9, 3.850306741590193*^9, 3.8505837517973013`*^9, 
   3.8512548712665567`*^9},
 CellLabel->"Out[40]=",ExpressionUUID->"9b861482-1039-4cb5-85bb-cc5cafca61bc"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Now", " ", "for", " ", "the", " ", 
   RowBox[{"proof", "!"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.815663493542923*^9, 3.815663502030469*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"8066388c-594e-4c6f-9dd5-3f3568e9c248"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"fx", ",", "fy"}], "}"}], "=", 
   RowBox[{"ptF", "=", "centerABE"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"gx", ",", "gy"}], "}"}], "=", 
   RowBox[{"ptG", "=", "centerADE"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"hx", ",", "hy"}], "}"}], "=", 
   RowBox[{"ptH", "=", "centerBCE"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ix", ",", "iy"}], "}"}], "=", 
   RowBox[{"ptI", "=", "centerCDE"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"slopeFG", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"gy", "-", "fy"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"gx", "-", "fx"}], ")"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"slopeHI", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"hy", "-", "iy"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"hx", "-", "ix"}], ")"}]}], " ", "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"slopeFH", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"fy", "-", "hy"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"fx", "-", "hx"}], ")"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"slopeGI", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"gy", "-", "iy"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"gx", "-", "ix"}], ")"}]}], " ", "//", "Simplify"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.815663508473181*^9, 3.815663515974573*^9}, {
  3.815663549766704*^9, 3.815663801543715*^9}, {3.8156638471208963`*^9, 
  3.815663891881894*^9}, {3.815670023808873*^9, 3.8156700245833187`*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"97e2a1bc-5fed-42d1-8852-9646c83752cc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"slopeFG", ",", "slopeHI"}], "}"}]], "Input",
 CellChangeTimes->{{3.8156638057839937`*^9, 3.8156638149436617`*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"2a823c6e-f6fb-419e-87cd-67489569f76c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "ay"}], " ", "dx", " ", "dy"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "ax"}], ")"}], " ", 
      SuperscriptBox["dx", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "k"}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "ax"}], ")"}], " ", 
      SuperscriptBox["dy", "2"], " ", "k"}]}], 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "ax"}], ")"}], " ", "dx", " ", "dy"}], "-", 
     RowBox[{"ay", " ", 
      SuperscriptBox["dy", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "k"}], ")"}]}], "-", 
     RowBox[{"ay", " ", 
      SuperscriptBox["dx", "2"], " ", "k"}]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "ay"}], " ", "dx", " ", "dy"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "ax"}], ")"}], " ", 
      SuperscriptBox["dx", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "k"}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "ax"}], ")"}], " ", 
      SuperscriptBox["dy", "2"], " ", "k"}]}], 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "ax"}], ")"}], " ", "dx", " ", "dy"}], "-", 
     RowBox[{"ay", " ", 
      SuperscriptBox["dy", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "k"}], ")"}]}], "-", 
     RowBox[{"ay", " ", 
      SuperscriptBox["dx", "2"], " ", "k"}]}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8156638158017683`*^9, 3.815663896719887*^9, {3.815664251313561*^9, 
   3.815664269096902*^9}, 3.8156648562142477`*^9, 3.8503067576266623`*^9, 
   3.850583766187315*^9, 3.85125487132197*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"d0361601-a778-4ff1-9e45-cce5b4c303f2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"slopeFG", "-", "slopeHI"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.815663819176125*^9, 3.815663831207715*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"d80b7d26-f0fb-485c-b7c6-7c581d752ab7"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.815664269132167*^9, 3.815664856255002*^9, 
  3.8503067606011066`*^9, 3.850583771933261*^9, 3.851254871359125*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"dd9a57e0-ba96-4a4f-b29c-00e420910725"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"slopeFH", "-", "slopeGI"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.8156639189923763`*^9, 3.8156639221124077`*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"e116f92f-fef6-40da-9103-3aefcb610485"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.815664269140168*^9, 3.815664856263266*^9, 
  3.8503067633236094`*^9, 3.850583774908375*^9, 3.851254871368414*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"2a3ba38c-a6b1-472f-9b59-c25c60c30d0c"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{926, 1250},
WindowMargins->{{72, Automatic}, {Automatic, 10}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1006, 18, 196, "Text",ExpressionUUID->"a16683d9-b289-4d5a-a025-a9196fb82139",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[1589, 42, 156, 3, 67, "Section",ExpressionUUID->"d4a13e5d-e35b-494d-bc2c-5a27372e6028"],
Cell[1748, 47, 39431, 652, 143, "Input",ExpressionUUID->"14a64d69-00fa-49c0-953b-2ad7bbe78ef4",
 Evaluatable->False],
Cell[41182, 701, 395, 9, 81, "Text",ExpressionUUID->"6c77ebfc-22f8-4071-8dd1-2f722f3c0b60"],
Cell[41580, 712, 22769, 351, 228, "Graphics",ExpressionUUID->"6f6c173c-f9f5-4fe6-8558-84e3a967d7bd"],
Cell[CellGroupData[{
Cell[64374, 1067, 1856, 50, 178, "Input",ExpressionUUID->"b2570c19-013b-4a4c-a6e3-3b7cce44cbe5"],
Cell[66233, 1119, 691, 18, 54, "Output",ExpressionUUID->"2d942267-c2b4-41b6-9bcd-86c9710eb281"]
}, Open  ]],
Cell[CellGroupData[{
Cell[66961, 1142, 4365, 111, 430, "Input",ExpressionUUID->"0ec44dc8-aa5a-464b-8044-17659b67bb95"],
Cell[71329, 1255, 1424, 24, 253, "Output",ExpressionUUID->"d60f5512-047f-4a11-9dfd-187fe65fe90f"]
}, Open  ]],
Cell[72768, 1282, 2144, 56, 178, "Input",ExpressionUUID->"c2357f4f-b83e-482d-9bc5-4246c01fcb20"],
Cell[74915, 1340, 1648, 43, 136, "Input",ExpressionUUID->"c9ea235b-52b4-4a29-984c-be604779c0c5"],
Cell[76566, 1385, 716, 21, 30, "Input",ExpressionUUID->"e99adafa-ab78-48b6-ad56-17cbf72b5f24"],
Cell[77285, 1408, 427, 9, 30, "Input",ExpressionUUID->"04ba5bdd-4f3f-4dab-9c2e-3fe6017dc953"],
Cell[77715, 1419, 3655, 105, 283, "Input",ExpressionUUID->"c7cea900-0b63-49ac-8fc9-c28887904f3f"],
Cell[CellGroupData[{
Cell[81395, 1528, 3901, 95, 367, "Input",ExpressionUUID->"713cfbd3-2529-45e2-8882-82288ff468e7"],
Cell[85299, 1625, 2163, 39, 253, "Output",ExpressionUUID->"9b861482-1039-4cb5-85bb-cc5cafca61bc"]
}, Open  ]],
Cell[87477, 1667, 278, 5, 30, "Input",ExpressionUUID->"8066388c-594e-4c6f-9dd5-3f3568e9c248"],
Cell[87758, 1674, 1892, 60, 178, "Input",ExpressionUUID->"97e2a1bc-5fed-42d1-8852-9646c83752cc"],
Cell[CellGroupData[{
Cell[89675, 1738, 233, 4, 30, "Input",ExpressionUUID->"2a823c6e-f6fb-419e-87cd-67489569f76c"],
Cell[89911, 1744, 2068, 65, 57, "Output",ExpressionUUID->"d0361601-a778-4ff1-9e45-cce5b4c303f2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[92016, 1814, 237, 4, 30, "Input",ExpressionUUID->"d80b7d26-f0fb-485c-b7c6-7c581d752ab7"],
Cell[92256, 1820, 242, 3, 34, "Output",ExpressionUUID->"dd9a57e0-ba96-4a4f-b29c-00e420910725"]
}, Open  ]],
Cell[CellGroupData[{
Cell[92535, 1828, 241, 4, 30, "Input",ExpressionUUID->"e116f92f-fef6-40da-9103-3aefcb610485"],
Cell[92779, 1834, 242, 3, 34, "Output",ExpressionUUID->"2a3ba38c-a6b1-472f-9b59-c25c60c30d0c"]
}, Open  ]]
}, Open  ]]
}
]
*)

